<?php
/**
 * @version		$Id: README.php 1606 2012-05-22 00:01:32Z johanjanssens $
 * @category	DOCman
 * @package		DOCman16
 * @copyright	Copyright (C) 2003 - 2012 Johan Janssens. All rights reserved.
 * @license	    This file can not be redistributed without the written consent of the
 *				original copyright holder. This file is not licensed under the GPL.
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');
?>

DOCman v1.6 README
--------------------

*** IMPORTANT ***

PLEASE READ THE UPGRADE INSTRUCTIONS BELOW WHEN UPGRADING FROM AN OLDER VERSION!

ALWAYS BACK UP YOUR SYSTEM'S FILES AND DATABASE BEFORE (UN)INSTALLING ANYTHING!

TO MAKE SURE THE FILES HAVEN'T BEEN TAMPERED WITH, DOWNLOAD DOCMAN, ADDONS AND
TRANSLATIONS FROM THE OFFICIAL LOCATION AT http://www.joomladocman.com/


Table of Contents
-----------------
* About DOCman

* System Requirements
* Installation in Joomla! 1.6.x
* Installing translations
* Upgrading from 1.5.x to 1.6
* Upgrading from v1.4.x
* Upgrading from v1.3 RC1 or RC2
* Migrating DOCman from a Joomla! 1.0.x site to a Joomla! 1.5 site

* Official Addons
* Useful Links


About DOCman
------------
DOCman is an open source document management and download system for Joomla! v1.6. With this component you can manage documents across categories and make them available for download.

These are the main features of DOCman:

* Infinite categories and subcategories. The documents can be organized across custom categories and subcategories;
* Files can be hosted locally or on a remote server
* Access control: Documents can be assigned to specific user or to custom groups of users
* Download counter and log. You can display a download counter per document and all the downloads can be logged (by user, IP, browser, date and hour);
* Own search system. Documents can be searched by name and/or description. The search system integrates with Joomla! using an optional mambot;
* Anti-leech system. The built-in anti-leech system avoids direct linking to documents;
* Path protection. Real paths to documents are never displayed to users;
* Themes: The layout can be changed using custom themes;
* ... and much more!

System Requirements
-------------------
1. Joomla 1.6.x (recommended 1.6.3 or later).
2. PHP 5.2.4 or higher
3. Database: MySQL 5.0.4 or higher


Installation in Joomla! 1.6.x
-----------------------------
1. Check the system requirements. [Site -> System Information -> System Information]
2. Check your writing permissions. [Site -> System Information -> Directory Permissions]
3. Install DOCman using Joomla's installer. [Extensions -> Extension Manager]
4. If you're new to DOCman, we highly recommend you click the 'Add sample data'-button.
5. Review the configuration settings and save.

Installing translations
-----------------------
Unzip the translation file of your choice in the root of your Joomla installation.

Upgrading from 1.5.x to 1.6
-----------------------------
1. Backup your Joomla installation and database
2. On your Joomla! 1.5.x site install docman_export, just like you would install any other extension, from the component menu export your configuration options and database.
3. On your new Joomla! 1.6.x site install docman_import, just like you would install any other extension, from the component menu import the configuration and database you exported in the last step.

Upgrading from v1.4.x
------------------------------------------------
You cannot upgrade directly from 1.4.x to 1.6. First upgrade to 1.5, then upgrade to 1.6.
Follow the instructions in the 1.6.x readme file.

Upgrading from v1.3 RC1 or RC2
------------------------------
You cannot upgrade directly from 1.3.x to 1.5. First upgrade to 1.4, then upgrade to 1.5.
Follow the instructions in the 1.4.x readme file.

Migrating DOCman from a Joomla! 1.0.x site to a Joomla! 1.5 site
----------------------------------------------------------------
Download the file docman_migrator_plugins_[version].zip. Inside, there is a README file with instructions.


Useful Links
------------
* Site:
  http://www.joomladocman.com/

* Blog:
  http://blog.joomlatools.eu/

* FAQ:
  http://support.joomlatools.eu/

* Downloads & translations:
  http://www.joomlatools.eu/membercenter

* Forum Support:
  http://forum.joomlatools.eu/
