<?php
/**
 * @version		$Id: thumbs.php 74 2010-01-09 15:18:06Z mathias $
 * @category	DOCman
 * @package		DOCmanThumbs
 * @copyright	Copyright (C) 2003 - 2009 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

// requires
require_once(dirname(__FILE__).DS.'defines.php');

jimport( 'joomla.plugin.plugin' );
class plgDocmanThumbs extends JPlugin
{
	public function onFetchDocument($params) 
	{
	    global $_DOCMAN;

	 	$pluginParams = $this->params;
	
	    // DOCman config
	    $dmpath = $_DOCMAN->getCfg('dmpath', JPATH_ROOT.DS.'dmdocuments');
	
	    // Parameters
	    $id     = $params['id'];
	    $type   = $params['type'];
	
	    // get the document instance
	    $doc = & DOCMAN_Document::getInstance($id);

	    // check for existing thumbnail
	    if($doc->objDBTable->dmthumbnail) { return; }

	    // dmfilename exists?
	    if(!file_exists($dmpath)) { return; }
	    if(!file_exists($dmpath.DS.$doc->objDBTable->dmfilename)) { return; }

	    // check extension
	    $extensions = $pluginParams->get( 'extensions', _AT_FILETYPE_LIST );
	    if(!in_array(strtolower($doc->objFormatData->filetype), explode(',', $extensions))) { return; }
	
	    // Target path writable?
	    if(!is_writable(_AT_PATH_IMAGES)) { return; }

	    // build target filename
	    $output_format  = $pluginParams->get('output_format', 'png');
	    $target = _AT_PATH_IMAGES.DS.'~thumbs.'.$doc->objDBTable->dmfilename.'.'.date('U').'.'.$output_format;
						
	    // phpThumb
	    require_once(_AT_PATH_LIBRARIES.DS.'phpthumb'.DS.'phpthumb.class.php');
	    $phpThumb  = new phpThumb();
	
	    // parameters
	    $phpThumb->setSourceFilename( $dmpath.DS.$doc->objDBTable->dmfilename );
	    $phpThumb->setParameter('w',    $pluginParams->get('width', 64));
	    $phpThumb->setParameter('h',    $pluginParams->get('height', 64));
	    $phpThumb->setParameter('far',  'C');
	    $phpThumb->setParameter('f',    $pluginParams->get('output_format', 'png'));
	    $phpThumb->setParameter('q',    $pluginParams->get('jpeg_quality', 75));
	    $phpThumb->setParameter('bg',   $pluginParams->get('background_color', 'FFFFFF'));
	    if ($pluginParams->get('grayscale', 0)) {
	        $phpThumb->setParameter('fltr', 'gray' );
	    }

	    // generate
	    if ( !$phpThumb->GenerateThumbnail() ) { return; }

	    // render
	    if (!$phpThumb->RenderToFile($target)) { return; }
	    unset($phpThumb);
	
	    // assign thumbnail
	    $doc->objDBTable->dmthumbnail       = basename($target);
	    $doc->objFormatData->dmthumbnail    = $doc->objDBTable->dmthumbnail;
	    $doc->objFormatPath->thumb 			= DOCMAN_Utils::pathThumb($doc->objDBTable->dmthumbnail, 1);
	
	    // store
	    $doc->objDBTable->store();
	    return;
	}
}
