<?php
/**
 * @version		$Id: helper.php 1606 2012-05-22 00:01:32Z johanjanssens $
 * @category	DOCman
 * @package		DOCman15
 * @copyright	Copyright (C) 2003 - 2012 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

if( !defined('DS') ) define('DS', DIRECTORY_SEPARATOR);

require_once JPATH_ROOT.'/administrator/components/com_docman/docman.class.php';
global $_DOCMAN, $_DMUSER;
$_DOCMAN = new dmMainFrame();
$_DMUSER = $_DOCMAN->getUser();
require_once($_DOCMAN->getPath('classes', 'compat'));
define( '_DM_INSTALLER_ICONPATH', 'components/com_docman/images/');

jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');

class DMStatus
{
	var $_success = true;
	var $_msgs = array();

	function & getInstance()
	{
		static $instance;
		if(!isset($instance)) {
			$instance = new DMStatus;
		}
		return $instance;
	}
	function addMsg($msg)
	{
		$this->_msgs[] = $msg;
	}
	function getMsgs()
	{
		return $this->_msgs;
	}
	function set($success)
	{
		$this->_success = $success;
	}
	function get()
	{
		return $this->_success;
	}
}

/**
 * Helper functions for the installer
 * @static
 */
class DMInstallHelper
{
    function getFiles()
    {
    	$ext = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_docman'.DS.'ext';
    	return array(
			$ext.DS.'mod_docman_approval'.DS.'mod_docman_approval.php'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_approval'.DS.'mod_docman_approval.php',
			$ext.DS.'mod_docman_approval'.DS.'mod_docman_approval.xml'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_approval'.DS.'mod_docman_approval.xml',
			$ext.DS.'mod_docman_latest'.DS.'mod_docman_latest.php'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_latest'.DS.'mod_docman_latest.php',
			$ext.DS.'mod_docman_latest'.DS.'mod_docman_latest.xml'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_latest'.DS.'mod_docman_latest.xml',
			$ext.DS.'mod_docman_logs'.DS.'mod_docman_logs.php'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_logs'.DS.'mod_docman_logs.php',
			$ext.DS.'mod_docman_logs'.DS.'mod_docman_logs.xml'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_logs'.DS.'mod_docman_logs.xml',
			$ext.DS.'mod_docman_news'.DS.'mod_docman_news.php'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_news'.DS.'mod_docman_news.php',
			$ext.DS.'mod_docman_news'.DS.'mod_docman_news.xml'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_news'.DS.'mod_docman_news.xml',
			$ext.DS.'mod_docman_top'.DS.'mod_docman_top.php'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_top'.DS.'mod_docman_top.php',
			$ext.DS.'mod_docman_top'.DS.'mod_docman_top.xml'
				=>JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_top'.DS.'mod_docman_top.xml',

			$ext.DS.'plugins'.DS.'docman'.DS.'standardbuttons'.DS.'standardbuttons.php'
				=> JPATH_ROOT.DS.'plugins'.DS.'docman'.DS.'standardbuttons'.DS.'standardbuttons.php',
            $ext.DS.'plugins'.DS.'docman'.DS.'standardbuttons'.DS.'standardbuttons.xml'
            	=> JPATH_ROOT.DS.'plugins'.DS.'docman'.DS.'standardbuttons'.DS.'standardbuttons.xml',

            //$ext.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS
            //	=> JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink',
            $ext.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'doclink.xml'
            	=> JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'doclink.xml',
			$ext.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'doclink.php'
            	=> JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'doclink.php',

			$ext.DS.'plugins'.DS.'search'.DS.'docman'.DS.'docman.xml'
            	=> JPATH_ROOT.DS.'plugins'.DS.'search'.DS.'docman'.DS.'docman.xml',
            $ext.DS.'plugins'.DS.'search'.DS.'docman'.DS.'docman.php'
            	=> JPATH_ROOT.DS.'plugins'.DS.'search'.DS.'docman'.DS.'docman.php',

            $ext.DS.'mod_docman_catdown'.DS.'mod_docman_catdown.php'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_catdown'.DS.'mod_docman_catdown.php',
			$ext.DS.'mod_docman_latestdown'.DS.'mod_docman_latestdown.php'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_latestdown'.DS.'mod_docman_latestdown.php',
			$ext.DS.'mod_docman_lister'.DS.'mod_docman_lister.php'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_lister'.DS.'mod_docman_lister.php',
			$ext.DS.'mod_docman_mostdown'.DS.'mod_docman_mostdown.php'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_mostdown'.DS.'mod_docman_mostdown.php',
			$ext.DS.'mod_docman_catdown'.DS.'mod_docman_catdown.xml'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_catdown'.DS.'mod_docman_catdown.xml',
			$ext.DS.'mod_docman_latestdown'.DS.'mod_docman_latestdown.xml'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_latestdown'.DS.'mod_docman_latestdown.xml',
			$ext.DS.'mod_docman_lister'.DS.'mod_docman_lister.xml'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_lister'.DS.'mod_docman_lister.xml',
			$ext.DS.'mod_docman_mostdown'.DS.'mod_docman_mostdown.xml'
				=>JPATH_SITE.DS.'modules'.DS.'mod_docman_mostdown'.DS.'mod_docman_mostdown.xml',

            	);
    }

    function getFolders()
    {
    	return array(
			JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_approval',
			JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_latest',
			JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_logs',
			JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_news',
			JPATH_ADMINISTRATOR.DS.'modules'.DS.'mod_docman_top',
			JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink',
			JPATH_ROOT.DS.'plugins'.DS.'docman'.DS.'standardbuttons',
            JPATH_SITE.DS.'modules'.DS.'mod_docman_catdown',
			JPATH_SITE.DS.'modules'.DS.'mod_docman_latestdown',
			JPATH_SITE.DS.'modules'.DS.'mod_docman_lister',
			JPATH_SITE.DS.'modules'.DS.'mod_docman_mostdown',
			);
    }


    function copyFiles($is_update = false)
    {
    	clearstatcache();

    	$status = & DMStatus::getInstance();
        $root   = JPATH_ROOT;
        $site   = $root.DS.'components'.DS.'com_docman';
        $admin  = $root.DS.'administrator'.DS.'components'.DS.'com_docman';

        // dmdocuments
        $dmdoc  = $root.DS._DM_DEFAULT_DATA_FOLDER;
        if (!is_dir($dmdoc) && !$is_update) {
	        @mkdir ($dmdoc, 0755, true);
	        @copy  ($admin.DS.'htaccess.txt', $dmdoc.DS.'.htaccess' );
	        @copy  ($site.DS.'index.html', $dmdoc.DS.'index.html');
	        if(!file_exists($dmdoc.DS.'.htaccess')) {
	        	$status->addMsg("Couldn't secure <strong>$dmdoc</strong>. Please create the folder yourself. Next copy $admin".DS."htaccess.txt to $dmdoc".DS.".htaccess");
	        }
        }

        $admin_path = JPATH_ROOT.'/administrator/components/com_docman';
        if (!$is_update) 
        {
        	$exists = file_exists($admin_path.'/docman.config.defaults.php');
        	$copied = false;
        	if ($exists) {
        		$copied = JFile::copy($admin_path.'/docman.config.defaults.php', $admin_path.'/docman.config.php');
        	} 
        	
        	if (!$exists || !$copied) {
        		$status->addMsg('Cannot find default configuration file for DOCman. You need to save the configuration options yourself in the component.');
        	} else {
        		$changed = self::setDocumentPath();
        	}
        }

        // create the folders
		$folders = DMInstallHelper::getFolders();
		foreach($folders as $folder) {
			if (!is_dir($folder)) {
				JFolder::create($folder);
			}
		}
		
		// plugins/docman is separate, because we don't want to delete on uninstall
		$plugin_dirs = array(
			JPATH_ROOT.DS.'plugins'.DS.'docman',
			JPATH_ROOT.DS.'plugins'.DS.'docman'.DS.'standardbuttons',
			JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink',
			JPATH_ROOT.DS.'plugins'.DS.'search'.DS.'docman'
		);
		foreach($plugin_dirs as $folder) {
			if (!is_dir($folder)) {
				JFolder::create($folder);
			}
		}

		//create the files
		$files = DMInstallHelper::getFiles();

		foreach( $files as $src=>$dest )
		{
			JFile::copy($src, $dest);
			if(!file_exists($dest)){
				$status->addMsg("Couldn't copy the following file: <br /><strong>Source: </strong>$src<br /><strong>Destination</strong>$dest<br />");
			}
		}

		//create the folder of plugins editors-xtd doclink
		JFolder::copy(
			JPATH_ADMINISTRATOR.DS.'components'.DS.'com_docman'.DS.'ext'.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'images'.DS,
			JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'images',
			'',
			true // force
		);
		JFolder::copy(
			JPATH_ADMINISTRATOR.DS.'components'.DS.'com_docman'.DS.'ext'.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'lang'.DS,
			JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'lang',
			'',
			true // force
		);
		JFolder::copy(
			JPATH_ADMINISTRATOR.DS.'components'.DS.'com_docman'.DS.'ext'.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'popups'.DS,
			JPATH_ROOT.DS.'plugins'.DS.'editors-xtd'.DS.'doclink'.DS.'popups',
			'',
			true // force
		);
    }


    function insertInDb($is_update = false)
    {
    	$database = JFactory::getDBO();

		$table = JTable::getInstance('extension');
		
    	// Plugins
    	$query = "SELECT extension_id FROM #__extensions WHERE element = 'standardbuttons' AND folder='docman' AND type='plugin'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			$data = array(
				'name' => 'plg_docman_standardbuttons',
				'type' => 'plugin',
				'element' => 'standardbuttons',
				'folder' => 'docman',
				'client_id' => 0,
				'enabled' => 1,
				'access' => 1,
				'params' => array(
					'download' => '1',
					'view' => '1',
					'details' => '1',
					'edit' => '1',
					'move' => '1',
					'delete' => '1',
					'update' => '1',
					'reset' => '1',
					'checkout' => '1',
					'approve' => '1',
					'publish' => '1'
				)
			);	
			$table->bind($data);
			$table->store();
			$table->reset();
			$table->extension_id = null;
    	}
		
		$query = "SELECT extension_id FROM #__extensions WHERE element = 'docman' AND folder='search' AND type='plugin'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			$data = array(
				'name' => 'plg_search_docman',
				'type' => 'plugin',
				'element' => 'docman',
				'folder' => 'search',
				'client_id' => 0,
				'enabled' => 1,
				'access' => 1,
				'params' => array(
					'prefix' => 'Download:',
					'href' => 'download',
					'search_name' => '1',
					'search_description' => '1'
				)
			);	
			$table->bind($data);
			$table->store();
			$table->reset();
			$table->extension_id = null;
    	}

		$query = "SELECT extension_id FROM #__extensions WHERE element = 'doclink' AND folder='editors-xtd' AND type='plugin'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			$data = array(
				'name' => 'plg_editors-xtd_doclink',
				'type' => 'plugin',
				'element' => 'doclink',
				'folder' => 'editors-xtd',
				'client_id' => 0,
				'enabled' => 1,
				'access' => 1
			);	
			$table->bind($data);
			$table->store();
			$table->reset();
			$table->extension_id = null;
    	}

    	// Admin modules
    	$query = "SELECT id FROM #__modules WHERE  module = 'mod_docman_news'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			DMInstallHelper::_insertModule(array('title'=>'DOCman - News', 'position'=>'dmcpanel', 'module'=>'mod_docman_news', 'showtitle'=>1, 'params'=>'', 'ordering'=>1, 'published'=>1, 'client_id'=>1));
    	}

    	$query = "SELECT id FROM #__modules WHERE  module = 'mod_docman_approval'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			DMInstallHelper::_insertModule(array('title'=>'DOCman - Unapproved', 'position'=>'dmcpanel', 'module'=>'mod_docman_approval', 'showtitle'=>1, 'params'=>'', 'ordering'=>2, 'published'=>1, 'client_id'=>1));
    	}
		
    	$query = "SELECT id FROM #__modules WHERE  module = 'mod_docman_latest'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
    		DMInstallHelper::_insertModule(array('title'=>'DOCman - Latest docs', 'position'=>'dmcpanel', 'module'=>'mod_docman_latest', 'showtitle'=>1, 'params'=>'', 'ordering'=>3, 'published'=>1, 'client_id'=>1));
    	}

    	$query = "SELECT id FROM #__modules WHERE  module = 'mod_docman_top'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			DMInstallHelper::_insertModule(array('title'=>'DOCman - Top docs', 'position'=>'dmcpanel', 'module'=>'mod_docman_top', 'showtitle'=>1, 'params'=>'', 'ordering'=>4, 'published'=>1, 'client_id'=>1));
    	}

    	$query = "SELECT id FROM #__modules WHERE  module = 'mod_docman_logs'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			DMInstallHelper::_insertModule(array('title'=>'DOCman - Latest logs', 'position'=>'dmcpanel', 'module'=>'mod_docman_logs', 'showtitle'=>1, 'params'=>'', 'ordering'=>5, 'published'=>1, 'client_id'=>1));
    	}

    	// Frontend modules

    	$query = "SELECT id FROM #__modules WHERE module = 'mod_docman_catdown'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
    		DMInstallHelper::_insertModule(array('title'=>'DOCman - Category', 'position'=>'left', 'module'=>'mod_docman_catdown', 'showtitle'=>1, 'params'=>''));
    	}

    	$query = "SELECT id FROM #__modules WHERE module = 'mod_docman_latestdown'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			DMInstallHelper::_insertModule(array('title'=>'DOCman - Latest Downloads', 'position'=>'left', 'module'=>'mod_docman_latestdown', 'showtitle'=>1, 'params'=>''));
    	}

		$query = "SELECT id FROM #__modules WHERE module = 'mod_docman_lister'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
    		DMInstallHelper::_insertModule(array('title'=>'DOCman - Lister', 'position'=>'left', 'module'=>'mod_docman_lister', 'showtitle'=>1, 'params'=>''));
    	}

    	$query = "SELECT id FROM #__modules WHERE module = 'mod_docman_mostdown'";
    	$database->setQuery($query);
    	if(!$database->loadResult())
    	{
			DMInstallHelper::_insertModule(array('title'=>'DOCman - Most Downloaded', 'position'=>'left', 'module'=>'mod_docman_mostdown', 'showtitle'=>1, 'params'=>''));
    	}
    }

    function _insertModule($data)
    {
		$extension = JTable::getInstance('extension');
		$extension->bind(array(
			'name' => $data['module'],
			'type' => 'module',
			'element' => $data['module'],
			'client_id' => isset($data['client_id']) ? $data['client_id'] : 0
		));
		$extension->store();
	
    	$row = JTable::getInstance('module');
		$row->bind($data);
		
		$result = $row->store() ? $row->id : false;
		
		if ($result) {
			$query = "INSERT INTO #__modules_menu VALUES ($result, 0);";
			$db = JFactory::getDbo();
			$db->setQuery($query);
			$db->query();
		}

		return $row->store() ? $row->id : false;
    }
	
	function setDocumentPath()
	{
		global $_DOCMAN;
		$_DOCMAN->_setConfig();
		$_DOCMAN->setCfg('dmpath', JPATH_ROOT.DS._DM_DEFAULT_DATA_FOLDER);
		return $_DOCMAN->saveConfig();
	}

    function deleteFromDb()
     {
        $database = JFactory::getDBO();

        $queries = array(

        "DELETE FROM #__extensions WHERE element = 'standardbuttons' AND folder='docman'",
        "DELETE FROM #__extensions WHERE element = 'docman' AND folder='search'",
        "DELETE FROM #__extensions WHERE element = 'doclink' AND folder='editors-xtd'",
 		"DELETE FROM #__extensions WHERE element = 'mod_docman_latest'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_top'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_logs'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_approval'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_news'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_catdown'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_latestdown'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_lister'",
    	"DELETE FROM #__extensions WHERE element = 'mod_docman_mostdown'",
		
		"DELETE FROM #__modules WHERE module = 'mod_docman_catdown'",
		"DELETE FROM #__modules WHERE module = 'mod_docman_latestdown'",
		"DELETE FROM #__modules WHERE module = 'mod_docman_lister'",
		"DELETE FROM #__modules WHERE module = 'mod_docman_mostdown'",
		
		"DELETE FROM #__modules WHERE position = 'dmcpanel'"
        );

        foreach($queries as $query){
        	$database->setQuery($query);
        	$database->query();
        }


     }

	function cpanel($is_update = false)
    {
        ?><br /><br />
        <div class="cpanel">
            <div class="icon">
                <a href="index.php?option=com_docman" style="text-decoration:none;">
                    <img border="0" align="top" alt="Home" src="<?php echo JURI::root(true);?>/administrator/components/com_docman/images/dm_cpanel_48.png"/>
                    <br />
                    <span>Home</span>
                </a>
            </div><br />
        <?php if (!$is_update) { ?>
            <div class="icon">
                <a href="index.php?option=com_docman&amp;task=sampledata" style="text-decoration:none;">
                    <img border="0" align="top" alt="Add Sample Data" src="<?php echo JURI::root(true); ?>/administrator/components/com_docman/images/dm_newdocument_48.png"/>
                    <br />
                    <span>Add Sample Data</span>
                </a>
            </div>
        <?php } ?>
        </div>
        <?php
    }

    function removeFiles()
    {


        $files = DMInstallHelper::getFiles();

        foreach( $files as $file ){
            JFile::delete($file);
        }

        $folders = DMInstallHelper::getFolders();
        foreach($folders as $folder)
        {
        	JFolder::delete($folder);
        }

    }


    function getDefaultFiles(){
        return array( '.htaccess', 'index.html' );
    }

    function getComponentId()
    {
        static $id;

        if( !$id )
        {
            $database = JFactory::getDBO();
            $database->setQuery("SELECT extension_id FROM #__extensions WHERE element = 'com_docman' AND type = 'component'");
            $id =$database->loadResult();
        }
        return $id;
    }

    /**
     * Count items in tables
     */
    function cntDbRecords()
    {
        $database = JFactory::getDBO();
    	$cnt = array();
        $tables = DMInstallHelper::getTablesList();

        foreach( $tables as $table ){
            $database->setQuery("SELECT COUNT(*) FROM `$table`");
            $cnt[] = (int) $database->loadResult();
        }

        // count categories
        $database->setQuery("SELECT COUNT(*) FROM `#__docman_categories` WHERE `section` = 'com_docman'");
        $cnt[] = (int) $database->loadResult();

        return array_sum($cnt);
    }

    function removeTables()
    {
        $database = JFactory::getDBO();
        $tables = DMInstallHelper::getTablesList();

    	foreach( $tables as $table ){
            $database->setQuery("DROP TABLE `$table`");
            $database->query();
        }
    }

    function getTablesList(){
    	return array( '#__docman', '#__docman_groups', '#__docman_history', '#__docman_licenses', '#__docman_log');
    }

    /**
     * Count the number of files in the data folder
     */
    function cntFiles()
    {
    	global $_DOCMAN;

        $files = DMInstallHelper::getDefaultFiles();
        $dir = DOCMAN_Compat::mosReadDirectory( $_DOCMAN->getCfg( 'dmpath' ) );
        return count( array_diff( $dir, $files ));
    }

    function getInfo()
    {
    	$db = & JFactory::getDBO();
    	$version = new JVersion();
    	
    	$browsers = array("firefox", "msie", "opera", "chrome", "safari", 
                            "mozilla", "seamonkey",    "konqueror", "netscape", 
                            "gecko", "navigator", "mosaic", "lynx", "amaya", 
                            "omniweb", "avant", "camino", "flock", "aol"); 

        $agent = strtolower($_SERVER['HTTP_USER_AGENT']); 

        foreach($browsers as $browser) 
        { 
            if (preg_match("#($browser)[/ ]?([0-9.]*)#", $agent, $match)) 
            { 
                $browser = new stdclass;
                $browser->name = $match[1] ; 
                $browserversion  = explode('.', $match[2]);
                $browser->version = $browserversion[0]; 
                break ; 
            } 
        }
        
        $server = @php_uname('s').' '.@php_uname('r');
        if ($server == ' ') {
        	// php_uname is disabled
        	$server = 'Unknown';
        }

    	$info = array(
    		'Version'		=> _DM_VERSION,
    		'CMS'	=> $version->PRODUCT.' '.$version->RELEASE .'.'. $version->DEV_LEVEL,
    	    'Koowa'		=> class_exists('Koowa') &&  method_exists('Koowa', 'getVersion') ? Koowa::getVersion() : 0,
    		'PHP' 	=> phpversion(),
    		'DB'	=> $db->getVersion(),
    		'Server' => $_SERVER['SERVER_SOFTWARE'],
    		'OS' => $server,
    		'Browser' => ucfirst($browser->name),
    		'BrowserVersion' => ucfirst($browser->name).' '.$browser->version,
    		'Language' => JFactory::getLanguage()->getName(),
    	);
    	
    	// Let's just return an array so we can do whatever we want with it when we call it
    	return $info;
    }

    function removeDmdocuments()
    {
        global $_DOCMAN;

        $dmpath = $_DOCMAN->getCfg( 'dmpath' );

        $files = DMInstallHelper::getDefaultFiles();

    	foreach( $files as $file ) {
            @unlink ( $dmpath.DS.$file );
        }
        @rmdir( $dmpath );
    }
    
    function track($is_update = false)
    {
        $info = DMInstallHelper::getInfo();
        $infoString = '';
        foreach($info as $key => $value) {
            if (!empty($infoString)) {
                $infoString .= ',';
            }
            $infoString .= "'".$key."' : '".$value."'";
        }

        $event = $is_update ? 'DOCman Updates' : 'DOCman Installations';
        echo "<script type=\"text/javascript\"> var mp_protocol = (('https:' == document.location.protocol) ? 'https://' : 'http://'); document.write(unescape('%3Cscript src=\"' + mp_protocol + 'api.mixpanel.com/site_media/js/api/mixpanel.js\" type=\"text/javascript\"%3E%3C/script%3E')); </script> <script type='text/javascript'> try {  var mpmetrics = new MixpanelLib('0384351786a53939e8562a355ea21867'); } catch(err) { null_fn = function () {}; var mpmetrics = {  track: null_fn,  track_funnel: null_fn,  register: null_fn,  register_once: null_fn, register_funnel: null_fn }; } </script>";
        echo "<script type=\"text/javascript\">mpmetrics.track('".$event."', {
            ".$infoString."
        })</script>";
    }
}