<?php
/**
 * @version		$Id: email.php 181 2010-06-15 11:36:47Z mathias $
 * @category	DOCman
 * @package		DOCmanNotify
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

/*
These are the variables you can use in the body

Action				$this->action (upload, edit, or download)

Info
    Date			$this->info->date
    Time			$this->info->time
    OS				$this->info->os
    Browser 		$this->info->browser

User
    User ID			$this->user->id
    Name			$this->user->name
    Username		$this->user->username
    E-mail			$this->user->email
    Usertype		$this->user->usertype
    Group ID		$this->user->gid
    Registered		$this->user->registerDate
    Last Visit		$this->user->lastvisitDate
    IP				$this->user->ip

Site
    Site Name		$this->site->name
    Site Url		$this->site->url

File
    Filename		$this->file->name
    Mimetype		$this->file->mime
    Extension		$this->file->ext
    Filesize		$this->file->size
    File date		$this->file->date

Document
	Title			$this->doc->dmname
    ID				$this->doc->id
    Category ID		$this->doc->catid
    Category name	$this->doc->category
	Description		$this->doc->dmdescription
    Date			$this->doc->dmdate_published
    Owner			$this->doc->dmowner
    Filename		$this->doc->dmfilename
    Url				$this->doc->dmurl
    Hits			$this->doc->dmcounter
	Last Updated	$this->doc->dmlastupdateon
	License			$this->doc->dmlicense_display
    License ID		$this->doc->dmlicense_id
    Access			$this->doc->access
    Published		$this->doc->published
    Checked out		$this->doc->checked_out
    Time			$this->doc->checked_out_time
    Approved		$this->doc->approved
    Last Updater	$this->doc->dmlastupdateby
    Submitted by	$this->doc->dmsubmitedby
    Maintainer		$this->doc->dmmantainedby

 */
?>

<p>Hi,<br />
<?php echo $this->actionlang?>.<br />
<a href="<?php echo $this->site->url?>"><?php echo $this->site->url?></a>
</p>

<table style="border:1px silver dotted">
<tr>
    <th>Date</th>
    <td><?php echo $this->info->date?></td>
</tr>
<tr>
    <th>Time</th>
    <td><?php echo $this->info->time?></td>
</tr>
</table>

<br />

<table style="border:1px silver dotted">
<caption>User info</caption>
<tr>
    <th>Name</th>
    <td><?php echo $this->user->name?></td>
</tr>
<tr>
    <th>Username</th>
    <td><?php echo $this->user->username?></td>
</tr>
<tr>
    <th>E-mail</th>
    <td><?php echo $this->user->email?></td>
</tr>
<tr>
    <th>Usertype</th>
    <td><?php echo $this->user->usertype?></td>
</tr>
<tr>
    <th>IP</th>
    <td><?php echo $this->user->ip?></td>
</tr>
<tr>
    <th>Browser &amp; OS</th>
    <td><?php echo $this->info->browser?> on <?php echo $this->info->os?></td>
</tr>
</table>
<br />

<?php if( $this->action !='upload') {?>
    <table style="border:1px silver dotted">
        <caption>Document Info</caption>
        <tr>
            <th>Title</th>
            <td>
                <a href="<?php echo $this->doc->link?>">
                    <?php echo $this->doc->dmname?>
                </a>
            </td>
        </tr>
        <tr>
            <th>Description</th>
            <td><?php echo $this->doc->dmdescription?></td>
        </tr>
        <tr>
            <th>Owner</th>
            <td><?php echo $this->doc->dmowner?></td>
        </tr>
        <tr>
            <th>Hits</th>
            <td><?php echo $this->doc->dmcounter?></td>
        </tr>
        <tr>
            <th>Published</th>
            <td><?php echo $this->doc->published?></td>
        </tr>
    </table>
<?php } ?>
<br />

<table style="border:1px silver dotted">
<caption>File info</caption>
<tr>
    <th>Name</th>
    <td><?php echo $this->file->name?></td>
</tr>
<tr>
    <th>Mimetype</th>
    <td><?php echo $this->file->mime?></td>
</tr>
<tr>
    <th>Extension</th>
    <td><?php echo $this->file->ext?></td>
</tr>
<tr>
    <th>Filesize</th>
    <td><?php echo $this->file->size?></td>
</tr>
</table>
<br />
