<?php
/**
 * @version		$Id: docmanfile.php 153 2010-03-15 20:55:20Z mathias $
 * @category	DOCman
 * @package		DOCmanNotify
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

require_once NOTIFY_PATH.DS.'includes'.DS.'docmandata.php';

class NotifyFile extends NotifyDocmanData
{
    /**
     * @var string
     */
    protected $_key = 'file';

    /**
     * Populate object with data from docman
     */
	protected function _loadParams()
    {
    	global $_DOCMAN;
        $vars = array( 'name', 'mime', 'ext', 'size', 'date');

        foreach( $vars as $var ) {
            $this->_load( $var );
        }

        if( isset($this->_params['file']))
        {
            if( is_string( $this->_params['file'] ))
            {
                $this->name = $this->_params['file'];
                require_once $_DOCMAN->getPath('classes', 'file');
                $full = new DOCMAN_File($this->name, $_DOCMAN->getCfg('dmpath'));
                $this->mime 	= $full->mime;
                $this->ext 		= $full->ext;
                $this->size 	= $full->size;
                $this->data		= $full->date;
            }
        }


    }

}