<?php
/**
 * @version		$Id: docmandata.php 198 2011-05-27 13:38:08Z ercan $
 * @category	DOCman
 * @package		DOCmanNotify
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

class NotifyDocmanData
{
    /**
     * @var string
     *
     */
    protected $_params;

    /**
     * @var string
     */
    protected $_key;


    /**
     * Parameters received from DOCman's mambot handling
     */
    public function __construct( & $params ) {
        $this->_params = & $params;
        $this->_loadParams();
    }

    /**
     * Populate object with data from docman
     */
    protected function _loadParams()
    {
        //overload in child
        die('NotifyDocmanData::_loadParams( must be overloaded');
    }

    protected function _load( $var )
    {
        if( @isset( $this->_params[$this->_key]->$var ) && @$this->_params[$this->_key]->$var )
        {
            $this->$var = $this->_params[$this->_key]->$var;
        }
        else
        {
            $this->$var = JText::_('PLG_DOCMAN_NOTIFY_NOT_AVAILABLE');
        }
    }

    protected function _loadBool( $var )
    {
        if( isset( $this->_params[$this->_key]->$var )  )
        {
            $this->$var = (bool) $this->_params[$this->_key]->$var ? JText::_('PLG_DOCMAN_NOTIFY_YES') : JText::_('PLG_DOCMAN_NOTIFY_NO');
        }
        else
        {
            $this->$var = JText::_('PLG_DOCMAN_NOTIFY_NOT_AVAILABLE');
        }
    }

    protected function _loadUser( $var )
    {
        if( isset( $this->_params[$this->_key]->$var) &&  @$this->_params[$this->_key]->$var  )
        {
            $id = $this->_params[$this->_key]->$var;
            $this->$var = DOCMAN_Utils::getUserName( $id );
        }
        else
        {
            $this->$var = JText::_('PLG_DOCMAN_NOTIFY_NOT_AVAILABLE');
        }
    }


}