<?php
/**
 * @version		$Id: config.php 198 2011-05-27 13:38:08Z ercan $
 * @category	DOCman
 * @package		DOCmanNotify
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');


class NotifyConfig extends JParameter
{
	public function NotifyConfig()
	{
		parent::__construct( JPluginHelper::getPlugin('docman', 'notify')->params );
	}

	/**
	 * @static
	 */
	public static function getInstance()
	{
		static $instance;

		if( !isset($instance)) {
			$instance = new NotifyConfig();
		}

		return $instance;
	}

	public function getRecipients()
	{
		$cc = $this->get( 'cc', false );
		if($cc)
		{
			$string = explode( '|', $cc );
			return $string;
		}

		return false;
	}

	/**
	 * Find out if the specified action should be performed in the current
	 * application (site or admin)
	 *
	 * @param 	string 	$action
	 * @return 	boolean True if the action should be performed
	 */
	public function doAction( $action = '' )
	{
		$app = JFactory::getApplication()->isAdmin() ? 'admin' : 'site';

		return ( $this->get('on'.$action.'_'.$app, 0)); // onedit_site, onedit_admin etc...
	}
}