<?php

defined('_JEXEC') or die;

jimport('joomla.filesystem.file');

class DocmanImportController extends JController
{
	public $default_view = 'import';
	
	public $default_redirect = 'index.php?option=com_docman_import';
	
	public function import_config()
	{
		JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		
		
		$options = JRequest::getVar('options', null, 'request', 'array');
		$data_file = JRequest::getVar('config_file', null, 'files', 'array');
		if (empty($data_file) || empty($data_file['tmp_name'])) {
			return $this->setRedirect($this->default_redirect, JText::_('IMPORT_UPLOAD_FILE_ERROR'), 'error');
		}
		
		$path = $data_file['tmp_name'];
		$serial = file_get_contents($path);
		
		$object = unserialize($serial);
		
		if (!is_object($object)) {
			return $this->setRedirect($this->default_redirect, JText::_('IMPORT_INVALID_CONFIG_ERROR'), 'error');
		}
		
		$db = JFactory::getDBO();
		
		if (!empty($options['modules'])) {
			$table = JTable::getInstance('Module');
			$access = $table->access;
			foreach ($object->modules as $module) {
				$module = (array) $module;
				$module = array_intersect_key($module, array(
					'title'=>1, 'ordering'=>1, 'position'=>1, 'published'=>1, 'module'=>1, 'showtitle'=>1, 'params'=>1, 'client_id'=>1
				));
				$table->bind($module);
				$table->access = $access;
				
				if ($table->check() && $table->store()) {
					$db->setQuery(sprintf("INSERT INTO #__modules_menu VALUES (%d, %d)", $table->id, 0));
					$db->query();
				}
				
				$table->reset();
				$table->id = null;
			}
		}
		
		if (!empty($options['menus'])) {
			$table = JTable::getInstance('Menu');
			$access = $table->access;
			
			$db->setQuery("SELECT extension_id FROM #__extensions WHERE element= 'com_docman' AND type = 'component'");
			$component_id = $db->loadResult();
			
			foreach ($object->menus as $menu) {
				$menu = (array) $menu;
				$menu['title'] = $menu['name'];
				unset($menu['params']['menu_image']);
				
				$menu = array_intersect_key($menu, array(
					'title'=>1, 'menutype'=>1, 'alias'=>1, 'published'=>1, 'params'=>1
				));
				$menu['access'] = $access;
				$menu['component_id'] = $component_id;
				$menu['type'] = 'component';
				$menu['level'] = 1;
				$menu['link'] = 'index.php?option=com_docman&view=docman';
				
				$table->setLocation(0, 'last-child');
				$table->bind($menu);
				
				$table->check();
				$result = $table->store();
				
				$table->reset();
				$table->id = null;
			}
		}
		
		if (!empty($options['config'])) {
			require_once JPATH_ADMINISTRATOR.'/components/com_docman/docman.class.php';
			global $_DOCMAN;
			$_DOCMAN = new dmMainFrame();
			
			foreach ($object->config as $key => $value) {
				if ($key == 'dmpath') {
					continue;
				}
				$_DOCMAN->setCfg($key, $value);
			}
			$_DOCMAN->saveConfig();
		}
		$this->setRedirect($this->default_redirect, JText::_('IMPORT_IMPORT_CONFIG_SUCCESS'));
	}
		
	public function import_data()
	{
		JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$data_file = JRequest::getVar('data_file', null, 'files', 'array');
		$data_path = JRequest::getVar('data_path', null);
		if (empty($data_path) && (empty($data_file) || empty($data_file['tmp_name']))) {
			return $this->setRedirect($this->default_redirect, JText::_('IMPORT_UPLOAD_FILE_ERROR'), 'error');
		}
		
		$path = $data_path ? $data_path : $data_file['tmp_name'];
		$sql = file_get_contents($path);

		$db = JFactory::getDBO();
		$db->setQuery($sql);
		
		$result = $db->queryBatch();
			
		if ($result) {
			$this->setRedirect($this->default_redirect, JText::_('IMPORT_IMPORT_DATA_SUCCESS'));
		}
		else {
			$this->setRedirect($this->default_redirect, $db->getErrorMsg(), 'error');
		}
		
	}
}