<?php
/**
 * @version		$Id$
 * @category	DOCmanPopulate
 * @package		DOCmanPopulate15
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.model');
require_once JPATH_COMPONENT.DS.'models'.DS.'files.php';

class PopulateModelDocuments extends JModel
{

	public function getData()
	{
		$database 	= JFactory::getDBO();
		
		$filesmodel = new PopulateModelFiles;

		$FilesInDatabase = $this->getState('orphansonly', 1) ? $filesmodel->getData() : array(); //files that already have a doc entry
		
		$dmpath 	= $this->getState('dmpath');
		$skipfiles	= explode( "|", $this->getState('skipfiles'));
		
	    if(!$dmpath || !$handle = opendir($dmpath)) 
	    {
            throw new Exception("Problem opening dmdocuments directory <b>" . $dmpath
                    ."</b>. Make sure you have DOCman working correctly before using this component." );
        }
        
		$files = array();
        while (false !== ($file = readdir($handle))) 
        {
            if (!in_array($file, $skipfiles )
                    && !in_array($file, $FilesInDatabase)
                    && !is_dir($file) ) {
                $files[] = $file;
            }
        }
		if (in_array('.htaccess', $files)) {
			$files = array_diff($files, array('.htaccess'));
		}

        natcasesort($files);
		return $files;
	}

}
