<?php
/**
 * @version		$Id$
 * @category	DOCmanPopulate
 * @package		DOCmanPopulate15
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

class PopulateSelects extends JHtmlSelect
{
	function tree( &$src_list, $src_id, $tgt_list, $tag_name, $tag_attribs, $key, $text, $selected )
	{
		// establish the hierarchy of the menu
		$children = array();
		
		// first pass - collect children
		foreach ($src_list as $v ) {
			$pt = $v->parent;
			$list = @$children[$pt] ? $children[$pt] : array();
			array_push( $list, $v );
			$children[$pt] = $list;
		}
		// second pass - get an indent list of the items
		$ilist = JHTML::_('menu.treerecurse', 0, '', array(), $children );

		// assemble menu items to the array
		$this_treename = '';
		foreach ($ilist as $item) 
		{
			if ($this_treename) {
				if ($item->id != $src_id && strpos( $item->treename, $this_treename ) === false) {
					$tgt_list[] = JHTML::_('select.option', $item->id, $item->treename );
				}
			} else {
				if ($item->id != $src_id) {
					$tgt_list[] = JHTML::_('select.option', $item->id, $item->treename );
				} else {
					$this_treename = "$item->treename/";
				}
			}
		}
		// build the html select list
		return JHTML::_('populate.selects.genericlist', $tgt_list, $tag_name, $tag_attribs, $key, $text, $selected );
	}
	
	public function licenses($dmlicense_id) 
    {
        $database = JFactory::getDBO();

        $options[] =  JHTML::_('select.option', 0, '- No License -' );

        $database->setQuery("SELECT id, name FROM #__docman_licenses ORDER BY name");
        $licenses = $database->loadObjectList();

        if (is_array( $licenses ) ) {
            foreach ($licenses as $license) {
                $options[] = JHTML::_('select.option', $license->id, $license->name);
            }
        }

        return  JHTML::_('select.genericlist',  $options, 'dmlicense_id', '', 'value', 'text', $dmlicense_id );

    }
    
    public function owners ($selected, $owner = 'dmowner') // $owner = 'dmowner' or 'dmmantainedby'
    { 
        $database = JFactory::getDBO();

        // Default options
        $options[] = JHTML::_('select.option', _DM_PERMIT_NOOWNER,       '------ Select User ------');
        $options[] = JHTML::_('select.option', _DM_PERMIT_NOOWNER,       '------ General ------');
        $options[] = JHTML::_('select.option', _DM_PERMIT_CREATOR,       'Creator');
        $options[] = JHTML::_('select.option', _DM_PERMIT_REGISTERED,    'All Registered Users');
        if ($owner == 'dmowner' ) {
            $options[] = JHTML::_('select.option', _DM_PERMIT_EVERYBODY, 'Everybody');
        } else {
            $options[] = JHTML::_('select.option', _DM_PERMIT_NOACCESS,  'No User Access');
        }
        $options[] = JHTML::_('select.option', _DM_PERMIT_NOOWNER,       '------ Joomla Groups ------');
        $options[] = JHTML::_('select.option', _DM_PERMIT_AUTHOR,        'Author');
        $options[] = JHTML::_('select.option', _DM_PERMIT_EDITOR,        'Editor');
        $options[] = JHTML::_('select.option', _DM_PERMIT_PUBLISHER,     'Publisher');


        //groups
        $options[] = JHTML::_('select.option', _DM_PERMIT_NOOWNER,       '------ Docman Groups ------');
        $database->setQuery("SELECT groups_id AS id, groups_name AS name FROM #__docman_groups ORDER BY groups_name");
        $groups = $database->loadObjectList();
        if (is_array( $groups ) ) {
            foreach ($groups as $group) {
                $options[] = JHTML::_('select.option', ((-1 * $group->id) - 10), $group->name);
            }
        }


        //users
        $options[] = JHTML::_('select.option', _DM_PERMIT_NOOWNER,       '------ Users ------');
        $database->setQuery("SELECT id, CONCAT( username, ' ( ', name, ' )') AS name FROM #__users ORDER BY username");
        $users = $database->loadObjectList();
        if (is_array( $users ) ) {
            foreach ($users as $user) {
                $options[] = JHTML::_('select.option', $user->id, $user->name);
            }
        }


        return $html =  JHTML::_('select.genericlist', $options, $owner, '', 'value', 'text', $selected );

    }
    
    /**
	 * Copied from JHtmlSelect to not use a filter.
	 */
	public static function genericlist(
		$data, $name, $attribs = null, $optKey = 'value', $optText = 'text',
		$selected = null, $idtag = false, $translate = false
	) {
		// Set default options
		$options = array_merge(
			JHtml::$formatOptions,
			array(
				'format.depth' => 0,
				'id' => false,
			)
		);
		if (is_array($attribs) && func_num_args() == 3) {
			// Assume we have an options array
			$options = array_merge($options, $attribs);
		} else {
			// Get options from the parameters
			$options['id'] = $idtag;
			$options['list.attr'] = $attribs;
			$options['list.translate'] = $translate;
			$options['option.key'] = $optKey;
			$options['option.text'] = $optText;
			$options['list.select'] = $selected;
		}
		$attribs = '';
		if (isset($options['list.attr'])) {
			if (is_array($options['list.attr'])) {
				$attribs = JArrayHelper::toString($options['list.attr']);
			} else {
				$attribs = $options['list.attr'];
			}
			if ($attribs != '') {
				$attribs = ' ' . $attribs;
			}
		}

		$id = $options['id'] !== false ? $options['id'] : $name;
		$id = str_replace(array('[', ']'), '', $id);

		$baseIndent = str_repeat($options['format.indent'], $options['format.depth']++);
		$html = $baseIndent . '<select' . ($id !== '' ? ' id="' . $id . '"' : '')
			. ' name="' . $name . '"'
			. $attribs . '>'
			. $options['format.eol']
			. self::options($data, $options)
			. $baseIndent . '</select>'
			. $options['format.eol']
		;
		return $html;
	}
    	
    /**
     * Copied from JHtmlSelect to not use a filter.
     */
	public static function options(
		$arr, $optKey = 'value', $optText = 'text', $selected = null, $translate = false
	) {
		$options = array_merge(
			JHtml::$formatOptions,
			self::$_optionDefaults['option'],
			array(
				'format.depth' => 0,
				'groups' => true,
				'list.select' => null,
				'list.translate' => false,
			)
		);
		if (is_array($optKey)) {
			// Set default options and overwrite with anything passed in
			$options = array_merge($options, $optKey);
		} else {
			// Get options from the parameters
			$options['option.key'] = $optKey;
			$options['option.text'] = $optText;
			$options['list.select'] = $selected;
			$options['list.translate'] = $translate;
		}

		$html = '';
		$baseIndent = str_repeat($options['format.indent'], $options['format.depth']);

		foreach ($arr as $elementKey => &$element)
		{
			$attr = '';
			$extra = '';
			$label = '';
			$id = '';
			if (is_array($element))
			{
				$key = $options['option.key'] === null
					? $elementKey : $element[$options['option.key']];
				$text = $element[$options['option.text']];
				if (isset($element[$options['option.attr']])) {
					$attr = $element[$options['option.attr']];
				}
				if (isset($element[$options['option.id']])) {
					$id = $element[$options['option.id']];
				}
				if (isset($element[$options['option.label']])) {
					$label = $element[$options['option.label']];
				}
				if (isset($element[$options['option.disable']]) && $element[$options['option.disable']]) {
					$extra .= ' disabled="disabled"';
				}
			} elseif (is_object($element)) {
				$key = $options['option.key'] === null
					? $elementKey : $element->$options['option.key'];
				$text = $element->$options['option.text'];
				if (isset($element->$options['option.attr'])) {
					$attr = $element->$options['option.attr'];
				}
				if (isset($element->$options['option.id'])) {
					$id = $element->$options['option.id'];
				}
				if (isset($element->$options['option.label'])) {
					$label = $element->$options['option.label'];
				}
				if (isset($element->$options['option.disable']) && $element->$options['option.disable']) {
					$extra .= ' disabled="disabled"';
				}
			} else {
				// This is a simple associative array
				$key = $elementKey;
				$text = $element;
			}

			// The use of options that contain optgroup HTML elements was
			// somewhat hacked for J1.5. J1.6 introduces the grouplist() method
			// to handle this better. The old solution is retained through the
			// "groups" option, which defaults true in J1.6, but should be
			// deprecated at some point in the future.

			$key = (string) $key;
			if ($options['groups'] && $key == '<OPTGROUP>') {
				$html .= $baseIndent . '<optgroup label="'
					. ($options['list.translate'] ? JText::_($text) : $text)
					. '">' . $options['format.eol'];
				$baseIndent = str_repeat($options['format.indent'], ++$options['format.depth']);
			} else if ($options['groups'] && $key == '</OPTGROUP>') {
				$baseIndent = str_repeat($options['format.indent'], --$options['format.depth']);
				$html .= $baseIndent . '</optgroup>' . $options['format.eol'];
			} else {
				// if no string after hypen - take hypen out
				$splitText = explode(' - ', $text, 2);
				$text = $splitText[0];
				if (isset($splitText[1])) {
					$text .= ' - ' . $splitText[1];
				}

				if ($options['list.translate'] && !empty($label)) {
					$label = JText::_($label);
				}
				if ($options['option.label.toHtml']) {
					$label = htmlentities($label);
				}
				if (is_array($attr)) {
					$attr = JArrayHelper::toString($attr);
				} else {
					$attr = trim($attr);
				}
				$extra = ($id ? ' id="' . $id . '"' : '')
					. ($label ? ' label="' . $label . '"' : '')
					. ($attr ? ' ' . $attr : '')
					. $extra
				;
				if (is_array($options['list.select']))
				{
					foreach ($options['list.select'] as $val)
					{
						$key2 = is_object($val) ? $val->$options['option.key'] : $val;
						if ($key == $key2) {
							$extra .= ' selected="selected"';
							break;
						}
					}
				} elseif ((string)$key == (string)$options['list.select']) {
					$extra .= ' selected="selected"';
				}

				if ($options['list.translate']) {
					$text = JText::_($text);
				}

				// Generate the option, encoding as required
				$html .= $baseIndent . '<option value="'
					. ($options['option.key.toHtml'] ? htmlspecialchars($key, ENT_COMPAT, 'UTF-8') : $key) . '"'
					. $extra . '>'
					. $text
					. '</option>'
					. $options['format.eol']
				;
			}
		}

		return $html;
	}
}