<?php
/**
 * @version		$Id$
 * @category	DOCmanPopulate
 * @package		DOCmanPopulate15
 * @copyright	Copyright (C) 2003 - 2010 Johan Janssens and Mathias Verraes. All rights reserved.
 * @license		GNU GPLv2 <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>
 * @link     	http://www.joomladocman.org
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_COMPONENT.DS.'helpers'.DS.'formatter.php';

jimport( 'joomla.application.component.controller' );
class PopulateControllerDocuments extends JController
{

	public function display()
	{
        // check path
	    if ( TablePopulateParams::getInstance()->dmpath == '' ) 
	    {
            throw new Exception("Please go to the DOCman configuration first, check all settings and make sure to save." );
            return;
        }
        parent::display();
	}

	
	public function assign()
	{
		JRequest::checkToken() or jexit( 'Invalid Token' );
        
        $my       	= JFactory::getUser();
        $db 		= JFactory::getDBO();

        $apConfig   = TablePopulateConf::getInstance();
        $apParams   = TablePopulateParams::getInstance();


        $files	= JRequest::getVar('files', false, 'post');
        $catid	= JRequest::getInt('catid', false, 'post');

        // if not set in config, get defaults
        $dmowner		= $apConfig->dmowner		? $apConfig->dmowner		: $apParams->dmowner;
        $dmmantainedby	= $apConfig->dmmantainedby	? $apConfig->dmmantainedby	: $apParams->dmmantainedby;

        // count
        $success = 0; $failed = 0;
        foreach ($files as $file) 
        {
            $title = $apConfig->stripextension ? PopulateFormatter::stripExtension( $file ) : $file;
            $title = $apConfig->nicetitle ? PopulateFormatter::getNiceTitle( $title ) : $title;

            // filetimes
            $dmdate_published = $apParams->dmdate_published;
            $dmlastupdateon = $apParams->dmlastupdateon;
            if ($apConfig->usefiletime) 
            {
                $st = @stat($apParams->dmpath.'/'.escapeshellarg($file));
                if ($st) 
                {
                    $dmdate_published = strftime('%Y-%m-%d %T', $st[10]);
                    $dmlastupdateon = strftime('%Y-%m-%d %T', $st[9]);
                    // $dmdate_published = $dmlastupdateon;
                }
            }

            $db->setQuery(
                    "INSERT INTO `#__docman` "
                    ."\n SET "
                    ." \n `dmfilename`			= ".$db->quote($file)
                    .",\n `dmname`				= ".$db->quote($title)
                    .",\n `catid`				= ".(int) $catid
                    .",\n `dmdescription`		= ".$db->quote($apConfig->dmdescription)
                    .",\n `dmdate_published`    = ".$db->quote($dmdate_published)
                    .",\n `dmowner`				= ".(int) $dmowner
                    .",\n `published`			= ".(int) $apConfig->published
                    .",\n `dmurl`				= ".$db->quote($apConfig->dmurl)
                    .",\n `dmcounter`			= ".(int) $apParams->dmcounter
                    .",\n `checked_out`			= ".(int) $apParams->checked_out
                    .",\n `checked_out_time`	= ".$db->quote($apParams->checked_out_time)
                    .",\n `approved`			= ".(int) $apConfig->approved
                    .",\n `dmthumbnail`			= ".$db->quote($apConfig->dmthumbnail)
                    .",\n `dmlastupdateon`      = ".$db->quote($dmlastupdateon)
                    .",\n `dmlastupdateby`		= ".(int) $my->id
                    .",\n `dmsubmitedby`		= ".(int) $my->id
                    .",\n `dmmantainedby`		= ".(int) $dmmantainedby
                    .",\n `dmlicense_id`		= ".(int) $apConfig->dmlicense_id
                    .",\n `dmlicense_display`	= ".(int) $apConfig->dmlicense_display
                    .",\n `access`				= ".(int) $apConfig->access
                    .",\n `attribs`				= ".$db->quote($apConfig->attribs)
                    );
                    if (!$db->query())  {
                JError::raiseNotice('Error: '.$db->getErrorMsg());
            	$failed++;
            } else {
                $success++;
            }
        }
        $this->setRedirect('index.php?option=com_populate&view=documents', "$success documents added, $failed failed");

    }
		
}
